<?php
/**
 * @Template: options.php
 * @since: 1.0.0
 * @author: KP
 * @descriptions:
 * @create: 16-Nov-17
 */

if (!defined('ABSPATH')) die();

/**
 * theme_core_ie_options_export
 * @descriptions: Export options data of WP Settings
 * @param: $file
 */
function lqd_ie_options_export($file)
{
    global $wp_filesystem;

    $upload_dir = wp_upload_dir();

    $options = array();

    /* default. */
    $options['home'] = lqd_ie_options_get_home_page();
    $options['menus'] = lqd_ie_options_get_menus();
    $options['opt-name'] = lqd_ie_setting_get_opt_name($file);
    $options['export'] = !empty($_POST['lqd-ie-data-type']) ? $_POST['lqd-ie-data-type'] : array();

    /* wp options */
    $options['wp-options'] =lqd_ie_options_get_wp_options(apply_filters('lqd_ie_options_wp_options', array()));

    /* attachment */
    if (file_exists($upload_dir['basedir'] . '/cms-attachment-tmp.zip'))
        $options['attachment'] = $upload_dir['baseurl'] . '/cms-attachment-tmp.zip';

    $wp_filesystem->put_contents($file, json_encode($options), FS_CHMOD_FILE);
}

function lqd_ie_options_get_home_page()
{

    $home_id = get_option('page_on_front');

    if (!$home_id)
        return null;

    $page = new WP_Query(array('post_type' => 'page', 'posts_per_page' => 1, 'page_id' => $home_id));

    if (!$page->post)
        return null;

    return $page->post->post_name;
}

function lqd_ie_options_get_menus()
{

    $theme_locations = get_nav_menu_locations();

    if (empty($theme_locations))
        return null;

    foreach ($theme_locations as $key => $id) {
        $menu_object = wp_get_nav_menu_object($id);
        $theme_locations[$key] = $menu_object->slug;
    }

    return $theme_locations;
}

function lqd_ie_options_get_wp_options($options = array())
{
    if (empty($options))
        return $options;

    $_options = array();

    foreach ($options as $key) {
        $_options[$key] = get_option($key);
    }

    return $_options;
}


/**
 * Import wp options functions
 * @param $options
 */
function lqd_ie_options_import($options)
{
    global $import_result;
    foreach ($options as $key => $option) {
        switch ($key) {
            case 'home':
                lqd_ie_options_set_home_page($option);
                $import_result[] = esc_html__('Set home page successfully!', 'lqd-ie');
                break;
            case 'menus':
                lqd_ie_options_set_menus($option);
                $import_result[] = esc_html__('Import menus successfully!', LQD_TEXT_DOMAIN);
                break;
            case 'wp-options':
                lqd_ie_options_set_wp_options($option);
                $import_result[] = esc_html__('Import wp options successfully!', LQD_TEXT_DOMAIN);
                break;
        }
    }
}

function lqd_ie_options_set_home_page($slug)
{

    $page = new WP_Query(array('post_type' => 'page', 'posts_per_page' => 1, 'name' => $slug));

    if (!$page->post)
        return null;

    update_option('show_on_front', 'page');
    update_option('page_on_front', $page->post->ID);
}

function lqd_ie_options_set_menus($menus)
{
    if (!empty($menus)) {
        $new_setting = array();
        foreach ($menus as $key => $menu) {

            $_menu = get_term_by('slug', $menu, 'nav_menu');
            if ($_menu !== false) {
                $new_setting[$key] = $_menu->term_id;
            }
        }

        set_theme_mod('nav_menu_locations', $new_setting);

    }
}

function lqd_ie_options_set_wp_options($options = array())
{
    if (empty($options))
        return;

    foreach ($options as $key => $value) {
        update_option($key, $value);
    }
}
